label chapter2:

    nvl clear

    #fade in
    play rain1 "<from 50.0 loop 50.0>audio/rain.ogg" fadein 5.0
    scene forest
    show rain onlayer rainlayer
    with Fade(3.0,0.0,1.0)

    "The forest provided little protection from the rain."
    extend " Heavy raindrops pushed through the canopy with ease, slapping noisily against anything in their path."
    extend " That included Scar."

    window hide
    show scar clothed normal:
        xanchor 0.5
        pos (0.4, 0.05)
        zoom 0.75
    with dissolve
    window show

    extend " He had prepared for the weather, with most of his body covered in waterproofed clothing."
    extend " The same could not be said of Tail."

    window hide
    show tail hood happy:
        xanchor 0.5
        pos (0.6, 0.3)
        zoom 0.6
    with dissolve
    window show

    #play music "tail_theme.ogg"

    extend " Within a few minutes the rain had soaked through her cloak, and with hardly anything covering the rest of her body she soon looked like a drowned rat."
    extend " Her mood, however, did not match her sorry appearance."
    extend " If not for the gloomy forest surrounding her, she might have looked like a child playing on the beach: wet and happy."
    extend " To her, this was a big adventure, and a long-awaited dream."

    nvl clear

    "She hummed a little tune as they walked down the muddy forest road."
    extend " Normally, Scar would have snapped at her for singing."
    extend " Even setting aside the fact that her overly cheery demeanor got under his skin, common knowledge dictated that one should be as quiet as possible when traversing the Forest."
    extend " Make too much noise, and you risked drawing the attention of the bloodthirsty beasts that lurked within."
    extend " Today, however, the rain ensured that anything short of a bloodcurdling scream would be drowned out."

    window hide
    show scar clothed right-eye
    with dissolve
    window show

    "He glanced at Tail, eyeing her wet skin."
    extend " Assaulting her would be easy enough in the forest with no one around to interfere, but humans weren’t his only concern."
    extend " He had had enough encounters with the beasts of the Forest that he didn’t dare leave himself vulnerable like that."

    nvl clear

    "“Why are you still dressed like that, anyway?”"

    window hide
    show tail hood open smile
    with dissolve
    window show

    play music "audio/tailtest.ogg"

    "“‘Cause I’m an adventurer."
    extend " I’ve gotta look the part if I want to get work.”"

    "“And...that’s what you think an adventurer looks like?”"

    window hide
    show tail hood three mouth
    with dissolve
    window show

    "“Uh, {i}yeah{/i}."
    extend " The cool ones, anyway. I see them all the time in town square."
    extend " They always have these flashy outfits that are just oozing style.”"

    "Scar had a bad feeling about this."
    extend " “Do you even know why they dress like that?”"

    window hide
    show tail hood open smile
    with dissolve
    window show

    "“Because it rocks, duh."
    extend " Heck, I’d wanna dress like one even if I wasn’t an adventurer."
    extend " I actually thought a lot about what kind of outfit I wanted before I graduated."
    extend " I mean, I had to be ready, right?”"

    "Scar waited for an opportunity to interject, but she kept on going."

    nvl clear

    "“Okay, so you know how they basically fall into two types?"
    extend " You’ve got the big, armored, scary ones, and the skimpy, cute, sexy ones."
    extend " Obviously I had to go the sexy route."
    extend " I mean, if I covered myself in all that clunky armor I’d be hiding some of my best assets.”"

    "{i}Not to mention you wouldn’t even be able to stand in full plate armor{/i}, he thought."

    "“Even then it took me a while to decide exactly what style I wanted."
    extend " I mean, it had to be just right."
    extend " This is my big debut as an adventurer, you know?"
    extend " Plus, I only had one shot at it since it used up all my money."
    extend " I never knew how expensive these were.”"

    nvl clear

    window hide
    show scar clothed angry
    with dissolve
    window show

    "“Hold on."
    extend " You spent all your money on that?”"

    window hide
    show tail hood three mouth
    with dissolve
    window show

    "“Uh-huh."
    extend " It cost extra ‘cause the ones they had were too big, so they had to custom make it to fit me.”"

    "Scar stared at her in disbelief."
    extend " Whenever an orphan graduated from St. Anne’s they were paid an amount equal to one month’s living expenses, plus the cost of equipment to establish themselves as adventurers."
    extend " The orphanage called it an “allowance”."
    extend " In reality it was a loan, as each orphan was expected to make enough money adventuring to “donate” the amount they received back to the orphanage, with interest."
    extend " Scar didn’t know exactly what happened to the orphans who had failed to repay their debts, but the rumors were bad enough that he didn’t dare risk defaulting."

    nvl clear

    "“You didn’t buy anything else with your allowance?"
    extend " Not even a weapon?”"

    window hide
    show tail hood proud
    with dissolve
    window show

    "“Of {i}course{/i} I have a weapon.”"

    "She rolled her eyes, pulling out a dinky little dagger from a sheath at her waist."
    extend " Scar would have facepalmed if his gloves weren’t dripping wet."

    nvl clear

    window hide
    show scar clothed normal
    with dissolve
    window show

    "“Look."
    extend " You know that no one actually goes out in the field dressed like that, right?”"

    window hide
    show tail hood bored
    with dissolve
    window show

    "She cocked her head."
    extend " “What do you mean?”"

    "“I {i}mean{/i} that people only wear those things to attract clients."
    extend " Once they’re actually on the job, they change into something more practical."
    extend " You really think people are out there fighting monsters in a bikini?"
    extend " Make one mistake and you’re dead.”"

    "“I thought they were just so good they never got hit.”"

    "“Are {i}you{/i} that good?”"

    window hide
    show tail hood open smile with dissolve
    window show

    "“Undefeated so far!”"

    nvl clear

    stop music fadeout 3.0

    window hide
    show scar:
        xpos 0.55
    with MoveTransition(0.2)
    show scar:
        linear 0.2 xpos 0.4
    with hpunch
    show tail hood angry
    with dissolve
    window show

    "Scar smacked her in the head."

    "“Hey!”"

    "“If you can’t even dodge that, then you’re never going to last.”"

    "“No fair!"
    extend " I wasn’t ready.”"

    "Scar was at the end of his wits."

    window hide
    show scar clothed angry
    with dissolve
    window show

    "“{i}Nothing{/i} is fair out here, okay?” he shouted."
    extend " “This isn’t a game."
    extend " The beasts don’t announce that they’re coming."
    extend " They pounce, and if you’re not ‘ready’ they tear your throat out.”"

    window hide
    show scar clothed closed eyes
    with dissolve
    window show

    "Then, a deep breath."

    "“Some people die even when they {i}are{/i} ready.”"

    nvl clear

    window hide
    show tail hood bored
    with dissolve
    window show

    "Tail didn’t seem convinced."
    extend " Scar was starting to regret allowing her to come along."
    extend " In a combat situation, a novice like her could end up a liability."

    window hide
    show scar clothed angry
    with dissolve
    window show

    "“Listen."
    extend " I let you come with me, but if we get attacked, you’re on your own."
    extend " You didn’t hire me, so I’m not sticking my neck out for you.”"

    "Tail’s response was curt."
    extend " “I know."
    extend " I wanted a partner, not a bodyguard.”"

    nvl clear

    window hide
    hide scar
    hide tail
    with dissolve
    window show

    "The two walked in silence after that."
    extend " Tail had stopped humming for some time now."
    extend " Scar wondered if she was mad at him."
    extend " He had been a bit harsh with her, even if it was for her own good."
    extend " Seasoned adventurers knew that most of the time you had a pretty good chance of getting through the Forest without incident."
    extend " Reports varied, but Scar’s personal experience put the rate of beast attacks at around ten percent."
    extend " That was low enough that he would risk the journey alone now and then if he couldn’t find a suitable partner."
    extend " He had scraped through worse situations on his own, so he was reasonably confident in his abilities."
    extend " Of course, when talking with clients he tended to tell them twenty or twenty-five percent."
    extend " Even ten percent would be disastrous for merchants so they were happy to pay up, but it never hurt to inflate the chances a bit to make his services seem more necessary."

    nvl clear

    " Still, Tail was a big unknown on this journey."
    extend " Her inexperience could very well end up endangering them both, but being upset might make her even more unpredictable."
    extend " He knew he was in the right so he had no intent to apologize, but perhaps there was something he could say to mediate the situation."

    "Just as he was pondering that, the two came across a large puddle in the forest path."

    window hide
    show scar clothed normal:
        xanchor 0.5
        pos (0.25,0.05)
        zoom 0.75
    with dissolve
    window show

    extend " Scar circled around the side, avoiding it entirely."

    window hide
    show tail hood open smile:
        xanchor 0.5
        pos (0.6, 0.3)
        zoom 0.6
    with moveinright
    show tail:
        easein 0.2 xpos 0.55 ypos 0.1
        easeout 0.2 xpos 0.5 ypos 0.3
    pause 0.4
    play sound "audio/puddle.ogg"
    pause 0.2
    window show

    extend " Tail got a running start, jumped, and landed right in the middle of it."
    extend " Muddy water splashed everywhere, and she shrieked playfully as a few droplets landed on her."
    extend " Scar stopped and glared at her over his shoulder."
    extend " Tail looked back like she was trying not to laugh."


    "{i}Why do I even bother?{/i} he thought as he stomped off again."

    nvl clear

    window hide
    hide scar
    with moveoutleft
    hide tail
    with moveoutleft

    #stop music fadeout 3.0

    scene forest_dark
    with Fade(1.0,0.5,1.0)

    window show

    "An hour passed, and the sun was starting to set."
    extend " Scar cursed under his breath."
    extend " He had hoped to get to Windham before sundown, but the rain had slowed them down more than he thought."
    extend " Worse yet, the lowered visibility made every shadow, every strange sound seem like an impending attack."

    nvl clear

    "The leaves rustled."
    extend " Water slapped noisily against the undergrowth."
    extend " Was that the wind, or something sneaking through the brush?"
    extend " Lightning flashed behind the canopy."
    extend " The brief illumination only cast more shadows."
    play sound "audio/thunder.ogg"
    extend " Shortly after, a clap of thunder drowned out all else."
    extend " The crackling boom would have scared smaller animals into their dens — but a cunning predator could use the cacophony as cover, closing in on their prey."

    #twig snap sfx

    extend " A twig snapped."
    extend " Scar glared at Tail, but there was no debris on their path."
    extend " Something was nearby."
    extend " Or had he just imagined it?"
    extend " He stopped in his tracks, grabbing Tail’s wrist."

    window hide
    show scar:
        xpos 1.5
    show tail hood shock:
        xanchor 0.5
        pos (0.6, 0.3)
        zoom 0.6
    with dissolve
    window show

    "“Huh? What are you—”"

    nvl clear

    window hide
    show scar clothed angry:
        xanchor 0.5
        pos (0.5, 0.05)
        zoom 0.75
    with dissolve
    show tail:
        linear 0.1 xpos 0.55
    window show

    "Scar clapped his hand over her mouth, pressing her head to his chest."
    extend " She squirmed as she tried to break free, her lithe body wriggling and grinding against him."
    extend " Scar started to feel a hint of arousal despite himself."
    extend " A decade of celibacy had made him more sensitive than he had realized."

    "{i}God dammit, not now.{/i}"

    "“Something’s watching us,” he said."
    extend " “If you know what’s good for you, then stay still.”"

    window hide
    show tail hood determined
    with dissolve
    window show

    "Tail froze, nodding in acknowledgement."
    extend " Scar’s head whipped around, trying to get an impossible 360 degrees of visibility."
    extend " He strained his ears to listen for any sounds that made it through the constant static of wind and rain."
    extend " Slowly, he grasped the hilt of his sword, ready to draw at a moment’s notice."

    nvl clear

    "Just then, a rustle of leaves."
    extend " Five o’clock, behind a tree."
    extend " Scar’s eyes were rooted to that spot."
    extend " He was hesitant even to blink."
    extend " A moment of carelessness could lead to disaster, after all."
    extend " But what if that wasn’t the only enemy?"
    extend " What if they were acting in a group?"
    extend " As Scar tried to visualize the terrain in his head, deducing the most likely places for additional enemies to hide, Tail started to struggle."

    window hide
    show tail hood panic with hpunch
    window show

    "“Stop it.”"

    "She didn’t listen, continuing to pound her fist against his torso."

    window hide
    show tail with hpunch
    window show

    "“{i}Stop it,{/i}” he hissed."

    "She thrashed her head back and forth and slipped her head free long enough to say a single word."

    "“Left!”"

    nvl clear

    "Scar’s head whipped back around just in time to see a gray shadow leaping toward him."

    window hide
    scene black
    hide rain
    with PushMove(0.2, "pushup")
    window show

    stop rain1

    extend " He drew his sword, but not fast enough to hit with the blade."
    extend " His fist made contact with the shadow in midair, sending it sliding across the ground."
    extend " For the first time, he got a look at his foe: a dire wolf."

    window hide
    scene cg_wolf1
    show rain onlayer rainlayer
    with CropMove(0.5, mode="wiperight")
    play music "<loop 40.61>audio/scarsfight.ogg"
    play rain1 "<loop 50.0>audio/rain.ogg" fadein 3.0
    play sound "audio/stormy_wind.ogg"
    pause 1.5
    window show

    extend " The beast quickly righted itself, fur matted with mud."
    extend " Scar could have finished it off while it was down, but he needed to know how many enemies he was facing."

    "He glanced over his shoulder."
    play sound "audio/wolf_bark.ogg"
    extend " Two wolves had emerged from behind the tree, circling in wait of an opportunity to strike."
    extend " The first wolf was likely the leader of the pack; if its attack had succeeded, the other two would have followed suit."
    extend " He was lucky that Tail had caught his attention."
    extend " He had subdued plenty of wolves before, but three on one was still a tough matchup."

    nvl clear

    "“Stay close to me,” he said to Tail."
    extend " She nodded, drawing her dagger."
    extend " In truth, protecting her was the furthest thing from his mind."
    extend " He just didn’t want her to do something stupid and put him in danger."
    extend " Right now, his priority was knowing where all three wolves were."
    extend " If she got spooked and ran, one of them might chase after her, and once it had finished her off it might come back and ambush him at an inopportune moment."
    extend " With Tail nearby, if worse came to worst he might be able to use her as a decoy and run."

    "The alpha approached, teeth bared and growling."
    extend " Scar’s eyes were starting to adjust to the darkness."
    extend " He hated having to wait for his opponent to strike first, but charging in on his own would be too reckless."
    extend " Fortunately, he didn’t have to wait long."
    extend " The alpha leapt at Scar, head tilted and jaws open, aiming to tear his throat out."

    nvl clear

    window hide
    play sound "audio/wolf_snarl.ogg"
    scene cg_wolf2 with Fade(0.1,0.0,1.0,color="#fff")
    pause 0.5
    window show

    "Its mouth snapped shut, but not around his neck."
    extend " Scar had blocked with his off hand, the beast’s fangs easily slicing through his coat."
    extend " The wolf snarled, tugging on his arm like it had sunk its teeth into a juicy piece of meat, but Scar couldn’t feel a thing — the sole benefit of his fake arm."
    extend " However, giving his arm to the wolf for too long could be dangerous."
    extend " The prosthetic could get unseated if handled too roughly."
    extend " Still, it was a worthwhile tactic if it paid off, and this time it had."

    nvl clear

    "While the alpha was busy gnawing on a metallic frame, Scar glanced to the side just in time to see one of the other wolves jump at him."
    extend " His instincts took over, and before he was even conscious of it he had thrusted his sword, piercing the wolf through the heart."

    window hide
    play sound "audio/wolf_growl2.ogg"
    scene cg_wolf3 with dissolve
    pause 0.5
    window show

    extend " The wolf fell limp with a gurgling growl."
    extend " Scar retracted his blade and tried to do the same to the alpha, but the beast must have sensed his intentions and released its jaws, jumping backwards."

    nvl clear

    "Scar felt a dull pain in his left shoulder."
    extend " He would have to be more careful with that arm."
    extend " He hoped the tissue hadn’t torn, but didn’t have the luxury of giving the prosthetic a rest."
    extend " He readjusted his grip on the hilt of his blade, right hand on top, two fingers from his left on the bottom."
    extend " Growing up, all of his training had been with a two-handed sword."
    extend " After losing his arm, not only did he have to retrain his dominant hand, but he could only afford a prosthetic that could exert roughly half the strength of a real arm, so his weapon of choice changed to a bastard sword."
    extend " He had never fully adjusted."
    extend " Even though he had only lost a quarter of his output, it felt like he needed to try twice as hard to cut like he used to."

    nvl clear

    "The alpha still had its eyes locked on Scar."

    extend " His eyes flitted to the right."
    extend " The other wolf was still keeping its distance, wary after how easily the first had been dispatched."
    extend " If all went to plan, he would kill the alpha before its underling found its nerve."
    extend " Then, with only one foe remaining he could go on the offensive."
    extend " He glanced to the side again."
    extend " The other wolf had started backing away."
    extend " Was this his chance?"
    extend " Scar’s desire to end this as quickly as possible overcame his caution."
    extend " He jumped at the alpha, swinging his sword over his head."
    
    play sound "audio/wolf_growl.ogg"
    
    extend " He had hoped to feel the beast’s skull crack beneath his swing, but his blade merely cut air."

    window hide
    scene black
    show cg_wolf4:
        ypos 0.0
        linear 0.05 ypos -0.1
        linear 0.05 ypos 0.1
        linear 0.05 ypos -0.1
        linear 0.05 ypos 0.0
        pause 0.5
    window show

    extend " The wolf’s fangs bore down on him again, this time snapping its jaws shut mere inches from his face."
    extend " Scar’s right arm had caught the beast’s chest, barely keeping it at bay."

    nvl clear

    "Just then, Tail shrieked."
    extend " Scar cursed under his breath."
    extend " He had hoped to have more time to deal with the alpha."
    extend " Once the other wolf killed Tail, it would attack him in defense of its leader."
    extend " If his left arm had been intact, he could have stabbed the alpha and been done with it."
    extend " Now, he wasn’t confident he had enough strength to deal a fatal wound with just his prosthesis."
    extend " Unable to take his eyes off the alpha, he heard wet, squelching noises at regular intervals."
    extend " Not the sound of a wolf devouring a child."
    extend " Tail must be on the run."
    extend " He prayed she didn’t lead the wolf too far away."

    window hide

    nvl clear

    "“Help!” she cried."

    $ renpy.music.play("audio/wolf_snarl.ogg", "sound", relative_volume=0.3)

    "He heard growling, the wolf’s jaws snapping but seemingly not finding their mark."
    extend " Tail was better at dodging than he had expected."
    extend " He needed every second he could get as he struggled to push back the alpha."
    extend " Every time he tried to gain leverage, his feet would slide on the mud."
    extend " Luckily, the wolf was struggling with the same conditions."

    "Tail shrieked again, whimpering and shouting as she ran around, avoiding certain death once again."

    window hide
    scene forest_dark
    show scar clothed angry:
        xanchor 0.5
        pos (0.5, 0.05)
        zoom 0.75
    with dissolve
    window show

    "“Keep running!” he shouted."
    extend " “Don’t try to fight it."
    extend " You’re not ready.”"

    nvl clear

    "The only response was more squealing."
    extend " Scar hoped she didn’t end up attracting even more enemies, but knew it was pointless to try and make her stop."
    extend " For now, the longer she could draw this out, the better."
    extend " His wrestling match with the alpha was still deadlocked, but he knew he couldn’t keep this up forever."
    extend " Out of desperation, he started punching the wolf with his left arm."

    window hide
    play sound "audio/punch.ogg"
    show scar clothed insane with hpunch
    pause 0.3
    play sound "audio/punch.ogg"
    show scar with hpunch
    pause 0.4
    play sound "audio/punch.ogg"
    show scar with hpunch
    pause 0.3
    window show

    extend " The blows weren’t strong enough to do any lasting damage, but that wasn’t the point."
    extend " Distracted by these new attacks, the wolf tried to bend away from Scar."
    extend " Its paws slipped on the mud, weakening its stance."
    extend " Scar stepped in, using the wolf’s own weight against it to flip it on its back, and pinned it to the ground."
    extend " He fell upon the beast, piercing its chest with his blade over and over."

    $ renpy.music.play("audio/wolf_growl2.ogg", "sound", relative_volume=0.5)

    extend " It flailed its limbs trying to claw at its attacker, but it was too late."
    extend " It soon fell still, fur stained with red."

    nvl clear

    window hide
    show scar clothed angry right-eye
    with dissolve
    window show

    "Scar had no time to breathe a sigh of relief — the fight wasn’t over."
    extend " No sooner had he yanked his sword from the alpha’s corpse than he heard a thud and another shriek."
    extend " His head whipped around."

    window hide
    scene black
    with CropMove(0.2, "wipeleft")
    scene forest_dark
    with CropMove(0.2, "wipeleft")
    window show

    extend " Tail had tripped and fallen."
    extend " She scrambled to get up, but kept slipping in the mud."
    extend " The remaining wolf had wasted no time pouncing on its prey."
    extend " Victory was in its grasp."
    extend " Tail tried to squirm out, but a dire wolf was much too heavy for a child to budge."
    extend " The wolf opened its maw."
    extend " Fangs which had torn apart countless creatures before today now bore down on Tail."
    extend " She clenched her eyes shut, bracing for unimaginable pain."

    stop rain1
    window hide
    nvl clear
    scene red
    hide rain onlayer rainlayer
    with Dissolve(0.1)
    stop music
    play sound "audio/bloody_slash.ogg"
    scene black with Dissolve(3.0)
    window show

    "\nHot blood spilled down her neck."

    "\nAn artery must have been severed."

    "\nBut the pain never came."

    nvl clear

    "Tail fearfully opened her eyes."
    extend " Raindrops blurred her vision."
    extend " She blinked a few times."
    extend " The wolf was still on top of her, but something was strange."
    extend " Its head dangled limply, its jaw slack."

    window hide
    scene forest_dark
    show rain onlayer rainlayer
    play rain1 "<from 50.0 loop 50.0>audio/rain.ogg" fadein 3.0
    with Dissolve(5.0)
    window show

    extend " Scar retracted his sword from the wolf’s neck."
    extend " The blade had severed its spine and cut through its windpipe, but had stopped just short of beheading it completely."
    extend " Still attached by a flap of skin, the wolf’s head lolled to the side, revealing a grisly cross section."
    extend " Scar returned his sword to its sheath and pushed the dead wolf off of her."
    extend " Tail was too shaken to move."
    extend " Panting, Scar held out his hand."

    "“Here.”"

    nvl clear

    window hide
    show scar clothed normal:
        xanchor 0.5
        pos (0.5, 0.05)
        zoom 0.75
    show tail battered dead eyes:
        xanchor 0.5
        pos (0.7, 0.3)
        zoom 0.6
    with dissolve
    window show

    "She looked at his hand in a daze, not understanding."
    extend " He grabbed Tail’s arm and pulled her to her feet."
    extend " Her legs were so weak she almost fell right back down."
    extend " She looked miserable, caked with mud and wolf blood, clothes dirty and torn."
    extend " Her bikini armor was practically falling off her body, but that seemed to be the last of her concerns."
    extend " She stared at the dead wolf, still breathing heavily."

    "“Come on."
    extend " We need to get moving.”"

    "Scar took her hand and dragged her off."

    nvl clear

    window hide
    show scar:
        linear 0.5 xpos 0.6
    pause 0.5
    show scar:
        linear 0.5 xpos 0.4
    show tail:
        linear 0.5 xpos 0.5
    pause 1
    show scar:
        linear 0.5 xpos 0.2
    show tail:
        linear 0.5 xpos 0.3
    pause 1
    show scar:
        linear 0.5 xpos 0.0
    show tail:
        linear 0.5 xpos 0.1
    pause 1
    show scar:
        linear 0.5 xpos -0.2
    show tail:
        linear 0.5 xpos -0.1
    pause 1
    #hide scar
    #hide tail
    #with moveoutleft

    jump chapter3