﻿init python:
    renpy.music.register_channel("rain1","sfx",tight=True)
    renpy.music.register_channel("rain2","sfx",tight=True)
    rain_speed_min = 3000
    rain_speed_max = 4000
    renpy.add_layer("rainlayer",above="transient")
    start_game_fade_time = 2.0

define narrator = NVLCharacter(
    who_style='nvl_label',
    what_style='nvl_thought',
    window_style='nvl_entry',
    type='nvl',
    mode='nvl',
    clear=False,
    kind=adv,
    what_layout = "greedy"
    )

image ctc = Animation("ctc1.png", 0.2, "ctc2.png", 0.2, "ctc3.png", 0.2, "ctc2.png", 0.2, xpos=0, ypos=0.1, xanchor=0, yanchor=0)

define config.nvl_page_ctc = "ctc"

define config.main_menu_music = "<loop 15.0>audio/wind_loop.ogg"

default preferences.text_cps = 50

default debug = False

define scars_theme_flag = False

transform moveinright_time(time, x):
    xanchor 0.5 xpos 1.1 ypos 0.05 zoom 0.75
    linear time xpos x

image rain = Fixed(
        SnowBlossom("rain1x100.png",count=100,xspeed=0,yspeed=(rain_speed_min,rain_speed_max),fast=True,border=100),
        SnowBlossom("rain1x250.png",count=100,xspeed=0,yspeed=(rain_speed_min,rain_speed_max),fast=True,border=250),
        SnowBlossom("rain1x500.png",count=20,xspeed=0,yspeed=(rain_speed_min,rain_speed_max),fast=True,border=500))

image red = "#aa0000"

# The game starts here.

label start:
    $ quick_menu = False
    show screen dummy_main_menu
    scene black
    pause start_game_fade_time
    if debug:
        menu:
            "Chapter 1":
                jump chapter1
            "Chapter 2":
                jump chapter2
            "Chapter 3":
                jump chapter3
    else:
        jump chapter1

    return
